[TestFixture]
public class BomXmlTest
{
  private PiecePart p1;
  private PiecePart p2;
  private Assembly a;

  [SetUp]
  public void SetUp()
  {
    p1 = new PiecePart("997624", "Moja cz", 3.20);
    p2 = new PiecePart("7734", "Pieko", 666);
    a = new Assembly("5879", "Mj element");
  }

  [Test]
  public void CreatePart()
  {
    Assert.AreEqual("997624", p1.PartNumber);
    Assert.AreEqual("Moja cz", p1.Description);
    Assert.AreEqual(3.20, p1.Cost, .01);
  }

  [Test]
  public void CreateAssembly()
  {
    Assert.AreEqual("5879", a.PartNumber);
    Assert.AreEqual("Mj element", a.Description);
  }

  [Test]
  public void Assembly()
  {
    a.Add(p1);
    a.Add(p2);
    Assert.AreEqual(2, a.Parts.Count);
    Assert.AreEqual(a.Parts[0], p1);
    Assert.AreEqual(a.Parts[1], p2);
  }

  [Test]
  public void AssemblyOfAssemblies()
  {
    Assembly subAssembly = new Assembly("1324", "Podelement");
    subAssembly.Add(p1);
    a.Add(subAssembly);

    Assert.AreEqual(subAssembly, a.Parts[0]);
  }

  private string ChildText(XmlElement element, string childName)
  {
    return Child(element, childName).InnerText;
  }

  private XmlElement Child(XmlElement element, string childName)
  {
    XmlNodeList children = element.GetElementsByTagName(childName);
    return children.Item(0) as XmlElement;
  }

  [Test]
  public void PiecePart1XML()
  {
    PartExtension e = p1.GetExtension("XML");
    XmlPartExtension xe = e as XmlPartExtension;
    XmlElement xml = xe.XmlElement;
    Assert.AreEqual("Fragment czci", xml.Name);
    Assert.AreEqual("997624", ChildText(xml, "Numer czci"));
    Assert.AreEqual("Moja cz", ChildText(xml, "Opis"));
    Assert.AreEqual(3.2, Double.Parse(ChildText(xml, "Koszt")), .01);
  }

  [Test]
  public void PiecePart2XML()
  {
    PartExtension e = p2.GetExtension("XML");
    XmlPartExtension xe = e as XmlPartExtension;
    XmlElement xml = xe.XmlElement;
    Assert.AreEqual("Fragment czci", xml.Name);
    Assert.AreEqual("7734", ChildText(xml, "Numer czci"));
    Assert.AreEqual("Pieko",ChildText(xml, "Opis"));
    Assert.AreEqual(666, Double.Parse(ChildText(xml, "Koszt")), .01);
}

  [Test]
  public void SimpleAssemblyXML()
  {
    PartExtension e = a.GetExtension("XML");
    XmlPartExtension xe = e as XmlPartExtension;
    XmlElement xml = xe.XmlElement;
    Assert.AreEqual("Element", xml.Name);
    Assert.AreEqual("5879", ChildText(xml, "Numer czci"));
    Assert.AreEqual("Mj element", ChildText(xml, "Opis"));
    XmlElement parts = Child(xml, "Czci");
    XmlNodeList partList = parts.ChildNodes;
    Assert.AreEqual(0, partList.Count);
  }

  [Test]
  public void AssemblyWithPartsXML()
  {
    a.Add(p1);
    a.Add(p2);
    PartExtension e = a.GetExtension("XML");
    XmlPartExtension xe = e as XmlPartExtension;
    XmlElement xml = xe.XmlElement;
    Assert.AreEqual("Element", xml.Name);
    Assert.AreEqual("5879", ChildText(xml, "Numer czci"));
    Assert.AreEqual("Mj element",ChildText(xml, "Opis"));

    XmlElement parts = Child(xml, "Czci");
    XmlNodeList partList = parts.ChildNodes;
    Assert.AreEqual(2, partList.Count);

    XmlElement partElement = partList.Item(0) as XmlElement;
    Assert.AreEqual("Fragment czci", partElement.Name);
    Assert.AreEqual("997624", ChildText(partElement, "Numer czci"));

    partElement = partList.Item(1) as XmlElement;
    Assert.AreEqual("Fragment czci", partElement.Name);
    Assert.AreEqual("7734", ChildText(partElement, "Numer czci"));
  }

  [Test]
  public void PiecePart1toCSV()
  {
    PartExtension e = p1.GetExtension("CSV");
    CsvPartExtension ce = e as CsvPartExtension;
    String csv = ce.CsvText;
    Assert.AreEqual("Fragment czci,997624,Moja cz,3.2", csv);
  }

  [Test]
  public void PiecePart2toCSV()
  {
    PartExtension e = p2.GetExtension("CSV");
    CsvPartExtension ce = e as CsvPartExtension;
    String csv = ce.CsvText;
    Assert.AreEqual("Fragment czci,7734,Pieko,666", csv);
  }
  [Test]
  public void SimpleAssemblyCSV()
  {
    PartExtension e = a.GetExtension("CSV");
    CsvPartExtension ce = e as CsvPartExtension;
    String csv = ce.CsvText;
    Assert.AreEqual("Element,5879,Mj element", csv);
  }

  [Test]
  public void AssemblyWithPartsCSV()
  {
    a.Add(p1);
    a.Add(p2);
    PartExtension e = a.GetExtension("CSV");
    CsvPartExtension ce = e as CsvPartExtension;
    String csv = ce.CsvText;

    Assert.AreEqual("Element,5879,Mj element," +
      "{Fragment czci,997624,Moja cz,3.2}," +
      "{Fragment czci,7734,Pieko,666}"
      , csv);
  }

  [Test]
  public void BadExtension()
  {
    PartExtension pe = p1.GetExtension(
      "Ta nazwa nie pasuje do adnego rozszerzenia!");
    Assert.IsTrue(pe is BadPartExtension);
  }
}
